import flixel.addons.display.FlxBackdrop;
import flixel.addons.effects.FlxTrail;
import funkin.game.ComboRating;

var bgdistort:CustomShader = new CustomShader('heatwave');
var saiyanTrail:FlxTrail;


function create() comboRatings = [
	new ComboRating(0, "F", 0xFFbf0000),
	new ComboRating(0.5, "D", 0xFFff0000),
	new ComboRating(0.7, "C", 0xFFff6c00),
	new ComboRating(0.8, "B", 0xFFee9d00),
	new ComboRating(0.85, "A", 0xFFedc200),
	new ComboRating(0.95, "S", 0xFFfcfd00),
	new ComboRating(1, "S++", 0xFFfeff32),
];
function postCreate() {
	GameOverSubstate.script = 'data/scripts/gameovers/exe';
	sky2 = new FlxBackdrop(Paths.image("stages/hell/exesky2"), FlxAxes.X);
	sky2.velocity.set(-30, 0);
	sky2.scrollFactor.set(0.3, 0.3);
	sky2.x = 190;
	sky2.y = -50;
	sky2.antialiasing = false;
	sky2.scale.set(5, 5);
	insert(members.indexOf(wall), sky2); 
	add(sky2);
	
	skychase1.visible = false;
	sky2.visible = false;
	skychase2.visible = false;
	wall.visible = false;
    
	groundchase1.visible = false;
	ground2.visible = false;
	groundchase2.visible = false;
	aura.visible = false;
	ground3.visible = false;
    
	bgdistort.speed = 0.4;
	bgdistort.strength = 0.6;
	sky1.shader = bgdistort;

}



function onNoteCreation(event) {
	if (event.note.strumLine == playerStrums) return;

	event.cancel();

	var note = event.note;
	if (event.note.isSustainNote) {
		note.loadGraphic(Paths.image('game/notes/exe/arrowEnds'), true, 7, 6);
		note.animation.add("hold", [event.strumID]);
		note.animation.add("holdend", [4 + event.strumID]);
	} else {
		note.loadGraphic(Paths.image('game/notes/exe/arrows'), true, 17, 17);
		note.animation.add("scroll", [4 + event.strumID]);
	}
	note.scale.set(6, 6);
	note.updateHitbox();
}

function onStrumCreation(event) {
	if (event.player == 1) return;

	event.cancel();

	var strum = event.strum;
	strum.loadGraphic(Paths.image('game/notes/exe/arrows'), true, 17, 17);
	strum.animation.add("static", [event.strumID]);
	strum.animation.add("pressed", [4 + event.strumID, 8 + event.strumID], 12, false);
	strum.animation.add("confirm", [12 + event.strumID, 16 + event.strumID], 24, false);

	strum.scale.set(6, 6);
	strum.updateHitbox();
}


var time:Float = 0;
function update(elapsed)
{
	bgdistort.time = time;
	time += elapsed;
}

function activateTrail () {
	saiyanTrail = new FlxTrail(boyfriend, null, 8, 12, 0.3, 0.1);
	saiyanTrail.color = FlxColor.YELLOW;
	saiyanTrail.blend = 0;
	PlayState.instance.insert(PlayState.instance.members.indexOf(boyfriend)+1, saiyanTrail);
}

function beatHit(beat)
{
	switch (beat)
	{
		//stage 2
		case 192:
		 sky1.visible = false;
		 fire.visible = false;
		 ground.visible = false;
		
		 skychase1.visible = true;
		 groundchase1.visible = true;

		//stage 3
		case 256:
		 skychase1.visible = false;
		 groundchase1.visible = false;

		 sky2.visible = true;
		 ground2.visible = true;
		
		//stage 4
		case 512:
		 sky2.visible = false;
		 ground2.visible = false;

		 skychase2.visible = true;
		 groundchase2.visible = true;

		//stage 5
		case 576:
		 skychase2.visible = false;
		 groundchase2.visible = false;
		 
		 wall.visible = true;
		 aura.visible = true;
		 ground3.visible = true;
	}
}